// Autor: Gustav Matula

#include <cstdio>
#include <cstring>

#include <vector>
#include <set>
#include <map>
#include <iostream>
#include <algorithm>
#include <cassert>

using namespace std;
typedef long long llint;
const llint inf = 1e10;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)

#define TRACE(x) cerr << #x << " = " << x << endl
#define _ << " _ " <<

string s;
int pos;

llint parse_num() {
  llint n = 0;
  while (isdigit(s[pos])) {
    n = n * 10 + s[pos] - '0';
    ++pos;
  }
  return n;
}

struct Comp {
  char l, r;
  llint len;
  llint rlen;

  virtual Comp *prefix(llint k) = 0;
  virtual Comp *reverse() = 0;
};

struct Raw : Comp {
  string w;

  static Raw *parse() {
    string w = "";
    while (isalpha(s[pos])) 
      w += s[pos++];
    return new Raw(w);
  }

  Raw(string w) : w(w) {
    len = (int)w.size();
    l = w[0];
    r = w[len - 1];

    rlen = 0;
    char last = '$';
    REP(i, len) {
      if (w[i] != last) ++rlen;
      last = w[i];
    }
  }

  Comp *prefix(llint k) { 
    return new Raw(w.substr(0, k)); 
  }

  Comp *reverse() {
    string z = w;
    std::reverse(z.begin(), z.end());
    return new Raw(z);
  }
};

Comp *parse_expr();

struct Conc : Comp {
  vector< Comp* > v;

  static Conc *parse() {
    vector< Comp* > v;

    while (pos < (int)s.size() && (isdigit(s[pos]) || isalpha(s[pos]))) 
      v.push_back(parse_expr());

    return new Conc(v);
  }

  Conc(vector< Comp* > v) : v(v) {
    int n = (int)v.size();
    l = v[0]->l;
    r = v.back()->r;
    
    len = 0;
    REP(i, n) len = min(inf, len + v[i]->len);

    rlen = v[0]->rlen;
    FOR(i, 1, n) rlen = rlen + v[i]->rlen - (v[i - 1]->r == v[i]->l);
  }

  Comp *prefix(llint k) {
    vector< Comp* > w;
    
    for (auto c : v) {
      if (c->len >= k) {
	w.push_back(c->prefix(k));
	return new Conc(w);
      } else {
	w.push_back(c);
	k -= c->len;
      }
    }

    return new Conc(w);
  }

  Comp *reverse() {
    vector< Comp* > w;

    for (auto c : v) 
      w.push_back(c->reverse());
    std::reverse(w.begin(), w.end());

    return new Conc(w);
  }
};

struct Mult : Comp {
  Comp *c;
  llint n;

  static Mult *parse() {
    int n = parse_num();
    ++pos;
    Mult *ret = new Mult(Conc::parse(), n);
    ++pos;
    return ret;
  }

  Mult(Comp *c, llint n) : c(c), n(n) {
    l = c->l;
    r = c->r;

    if (c->len >= inf / n)
      len = inf;
    else
      len = c->len * n;

    rlen = n * c->rlen - (l == r) * (n - 1);
  }

  Comp *prefix(llint k) {
    llint cnt = k / c->len;
    llint mod = k % c->len;

    if (cnt == 0 || k == c->len) return c->prefix(k);
    if (mod == 0) return new Mult(c, cnt);
    return new Conc({ new Mult(c, cnt), c->prefix(mod)});
  }

  Comp *reverse() {
    return new Mult(c->reverse(), n);
  }
};

Comp *parse_expr() {
  if (isdigit(s[pos]))
    return Mult::parse();
  else
    return Raw::parse();
}

int main(void) 
{
  cin >> s;
  Comp *S = Conc::parse();

  S = S->prefix(min((llint)1e9, S->len));

  int l, r;
  cin >> l >> r;
  cerr << S->len << endl;
  cout << S->prefix(r)->reverse()->prefix(r - l + 1)->rlen - 1 << endl;
  
  return 0;
}
